// Charge Anywhere Admin JavaScript
var caw_incChargeSet = 0;
var caw_incChargeAch = 0;
jQuery(document).ready(function() {
    jQuery('#woocommerce_chargeanywhere_accept_credit').change(function() {
        if (jQuery(this).is(':checked')) {
            displayCreditBoxes(false);
        } else {
            displayCreditBoxes(true);
        }
    });
    

    jQuery(document).on('input blur', '.refund_line_total', function() {
        validateRefundAmount(jQuery(this), 'total');
    });

    jQuery(document).on('input blur', '.refund_line_tax', function() {
        validateRefundAmount(jQuery(this), 'tax');
    });
  

    jQuery('#woocommerce_chargeanywhere_accept_ach').change(function() {
        if (jQuery(this).is(':checked')) {
            displayACHBoxes(false);
        } else {
            displayACHBoxes(true);
        }
    });

    jQuery('#woocommerce_chargeanywhere_apply_credit_service').change(function() {
        if (jQuery(this).is(':checked')) {
            disableCreditBoxes(false);
        } else {
            disableCreditBoxes(true);
        }
    });

    jQuery('#woocommerce_chargeanywhere_apply_credit_convenience_service').change(function() {
        if (jQuery(this).is(':checked')) {
            disableCreditBoxesConv(false);
        } else {
            disableCreditBoxesConv(true);
        }
    });

    jQuery('#woocommerce_chargeanywhere_apply_ach_service').change(function() {
        if (jQuery(this).is(':checked')) {
            disableACHBoxes(false);
        } else {
            disableACHBoxes(true);
        }
    });

    jQuery('#woocommerce_chargeanywhere_apply_ach_convenience_service').change(function() {
        if (jQuery(this).is(':checked')) {
            disableACHBoxesConv(false);
        } else {
            disableACHBoxesConv(true);
        }
    });

    jQuery('#woocommerce_chargeanywhere_transaction_mode').change(function() {
        if (jQuery(this).val() === 'authorize') {
            jQuery('#woocommerce_chargeanywhere_auto_complete_orders').prop('disabled', true).prop('checked', false);
        } else {
            jQuery('#woocommerce_chargeanywhere_auto_complete_orders').prop('disabled', false);
        }
    });

    loadData();
    jQuery("#woocommerce_chargeanywhere_credit_service_fee_type").css("width", "100%");
    jQuery("#woocommerce_chargeanywhere_ach_service_fee_type").css("width", "100%");
    
    // Initialize fee refund calculation system
    initializeFeeRefundCalculation();
})

function loadData() {

    if (jQuery("#woocommerce_chargeanywhere_accept_credit").is(':checked'))
        displayCreditBoxes(false);
        else
        displayCreditBoxes(true);

    if (jQuery("#woocommerce_chargeanywhere_apply_credit_service").is(':checked'))
        disableCreditBoxes(false);
    else
        disableCreditBoxes(true);
    
    
    if (jQuery("#woocommerce_chargeanywhere_accept_ach").is(':checked'))
        displayACHBoxes(false);
    else
        displayACHBoxes(true);

    if (jQuery("#woocommerce_chargeanywhere_apply_ach_service").is(':checked'))
        disableACHBoxes(false);
    else
        disableACHBoxes(true);

    if(jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").is(':checked'))
        disableCreditBoxesConv(false);
    else
        disableCreditBoxesConv(true);

    if(jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").is(':checked'))
        disableACHBoxesConv(false);
    else
        disableACHBoxesConv(true);

    if(jQuery("#woocommerce_chargeanywhere_transaction_mode").val() === 'authorize') {
        jQuery('#woocommerce_chargeanywhere_auto_complete_orders').prop('disabled', true).prop('checked', false);
    } else {
        jQuery('#woocommerce_chargeanywhere_auto_complete_orders').prop('disabled', false);
    }
}

function disableCreditBoxes(flag) {
    jQuery("#woocommerce_chargeanywhere_credit_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_credit_service_fee_value").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_apply_credit_tax_amount_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_credit_refund_service_fee").prop("disabled", flag);
    
}

function disableCreditBoxesConv(flag) {
    jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee_value").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_credit_refund_convenience_fee").prop("disabled", flag);
    
}

function displayCreditBoxes(flag) {
    jQuery("#woocommerce_chargeanywhere_apply_credit_service").closest('tr').addClass('credit-outer-table');
    jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").closest('tr').addClass('credit-outer-table2');

    if (!flag) {
        jQuery("#woocommerce_chargeanywhere_apply_credit_service").closest('tr').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_apply_credit_service").closest('td').css('padding-left', '40px');
        jQuery("#woocommerce_chargeanywhere_credit_service_fee").closest('tr').addClass('credit-row').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_credit_service_fee_value").closest('tr').addClass('credit-row').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_apply_credit_tax_amount_service_fee").closest('tr').addClass('credit-row').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_credit_refund_service_fee").closest('tr').addClass('credit-row').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").closest('tr').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").closest('td').css('padding-left', '40px');

        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee").closest('tr').addClass('credit-row2').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee_value").closest('tr').addClass('credit-row2').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_credit_refund_convenience_fee").closest('tr').addClass('credit-row2').css('display', 'table-row');
    } else {
        jQuery("#woocommerce_chargeanywhere_apply_credit_service").closest('tr').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_credit_service_fee").closest('tr').addClass('credit-row').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_credit_service_fee_value").closest('tr').addClass('credit-row').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_apply_credit_tax_amount_service_fee").closest('tr').addClass('credit-row').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_credit_refund_service_fee").closest('tr').addClass('credit-row').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").closest('tr').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee").closest('tr').addClass('credit-row2').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee_value").closest('tr').addClass('credit-row2').css('display', 'none');
        
        jQuery("#woocommerce_chargeanywhere_credit_refund_convenience_fee").closest('tr').addClass('credit-row2').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_credit_service_fee").val("");
        jQuery("#woocommerce_chargeanywhere_credit_service_fee_value").val("");
        jQuery("#woocommerce_chargeanywhere_credit_refund_service_fee").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_apply_credit_service").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_apply_credit_tax_amount_service_fee").prop("checked", false);

        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee").val("");
        jQuery("#woocommerce_chargeanywhere_credit_convenience_service_fee_value").val("");
        jQuery("#woocommerce_chargeanywhere_apply_credit_convenience_service").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_credit_refund_convenience_fee").prop("checked", false);
        
    }
    if (caw_incChargeAch == 0) {
        jQuery(".credit-outer-table").closest('tr').after("<tr class='credit-group'><th></th><td><table class='credit-table'></table></td></tr>");
        jQuery(".credit-row").each(function() {
            var html = "<tr class='credit-row'>";
            html += jQuery(this).html();
            html += "</tr>";
            jQuery(".credit-group .credit-table").append(html).css({"margin-left":"50px"});
            jQuery(this).remove();
        });

        jQuery(".credit-outer-table2").closest('tr').after("<tr class='credit-group2'><th></th><td><table class='credit-table2'></table></td></tr>");
        jQuery(".credit-row2").each(function() {
            var html = "<tr class='credit-row'>";
            html += jQuery(this).html();
            html += "</tr>";
            jQuery(".credit-group2 .credit-table2").append(html).css({"margin-left":"50px"});
            jQuery(this).remove();
        });
    }
    if (!flag) {
        jQuery(".credit-group").css("display", "table-row");
        jQuery(".credit-group2").css("display", "table-row");
        disableCreditBoxes(true)
    } else {
        jQuery(".credit-group").css("display", "none");
        jQuery(".credit-group2").css("display", "none");
        disableCreditBoxes(true)
    }

    if (jQuery("#woocommerce_chargeanywhere_apply_credit_service").is(':checked'))
        disableCreditBoxes(false)
    else
        disableCreditBoxes(true)
    caw_incChargeAch++;
}

function disableACHBoxes(flag) {
    jQuery("#woocommerce_chargeanywhere_ach_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_ach_service_fee_value").prop("disabled", flag);

    jQuery("#woocommerce_chargeanywhere_apply_ach_tax_amount_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_ach_refund_service_fee").prop("disabled", flag);

    
}

function disableACHBoxesConv(flag) {
    jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee_value").prop("disabled", flag);
    jQuery("#woocommerce_chargeanywhere_ach_refund_convenience_fee").prop("disabled", flag);
}

function displayACHBoxes(flag) {
    jQuery("#woocommerce_chargeanywhere_apply_ach_service").closest('tr').addClass('ach-outer-table');
    jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").closest('tr').addClass('ach-outer-table2');
    if (!flag) {
        jQuery("#woocommerce_chargeanywhere_apply_ach_service").closest('tr').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_apply_ach_service").closest('td').css('padding-left', '40px');
        jQuery("#woocommerce_chargeanywhere_ach_service_fee").closest('tr').addClass('ach-row').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_ach_service_fee_value").closest('tr').addClass('ach-row').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_apply_ach_tax_amount_service_fee").closest('tr').addClass('ach-row').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_ach_refund_service_fee").closest('tr').addClass('ach-row').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").closest('tr').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").closest('td').css('padding-left', '40px');
        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee").closest('tr').addClass('ach-row2').css('display', 'table-row');
        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee_value").closest('tr').addClass('ach-row2').css('display', 'table-row');

        jQuery("#woocommerce_chargeanywhere_ach_refund_convenience_fee").closest('tr').addClass('ach-row2').css('display', 'table-row');
    } else {
        jQuery("#woocommerce_chargeanywhere_apply_ach_service").closest('tr').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_ach_service_fee").closest('tr').addClass('ach-row').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_ach_service_fee_value").closest('tr').addClass('ach-row').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_apply_ach_tax_amount_service_fee").closest('tr').addClass('ach-row').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_ach_refund_service_fee").closest('tr').addClass('ach-row').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").closest('tr').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee").closest('tr').addClass('ach-row2').css('display', 'none');
        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee_value").closest('tr').addClass('ach-row2').css('display', 'none');

        jQuery("#woocommerce_chargeanywhere_ach_refund_convenience_fee").closest('tr').addClass('ach-row2').css('display', 'none');


        jQuery("#woocommerce_chargeanywhere_ach_service_fee").val("");
        jQuery("#woocommerce_chargeanywhere_ach_service_fee_value").val("");
        jQuery("#woocommerce_chargeanywhere_ach_refund_service_fee").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_apply_ach_service").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee").val("");
        jQuery("#woocommerce_chargeanywhere_apply_ach_tax_amount_service_fee").prop("checked", false);

        jQuery("#woocommerce_chargeanywhere_ach_convenience_service_fee_value").val("");
        jQuery("#woocommerce_chargeanywhere_apply_ach_convenience_service").prop("checked", false);
        jQuery("#woocommerce_chargeanywhere_ach_refund_convenience_fee").prop("checked", false);
    }
    if (caw_incChargeSet == 0) {
        jQuery(".ach-outer-table").closest('tr').after("<tr class='ach-group'><th></th><td><table class='ach-table'></table></td></tr>");

        jQuery(".ach-row").each(function() {
            var html = "<tr class='ach-row'>";
            html += jQuery(this).html();
            html += "</tr>";
            jQuery(".ach-group .ach-table").append(html).css({"margin-left":"50px"});
            jQuery(this).remove();
        })

        jQuery(".ach-outer-table2").closest('tr').after("<tr class='ach-group2'><th></th><td><table class='ach-table2'></table></td></tr>");

        jQuery(".ach-row2").each(function() {
            var html = "<tr class='ach-row'>";
            html += jQuery(this).html();
            html += "</tr>";
            jQuery(".ach-group2 .ach-table2").append(html).css({"margin-left":"50px"});
            jQuery(this).remove();
        })
    }
    if (!flag) {
        jQuery(".ach-group").css("display", "table-row");
        jQuery(".ach-group2").css("display", "table-row");
        disableACHBoxes(false)
    } else {
        jQuery(".ach-group").css("display", "none");
        jQuery(".ach-group2").css("display", "none");
        disableACHBoxes(true)
    }
    if (jQuery("#woocommerce_chargeanywhere_apply_ach_service").is(':checked'))
        disableACHBoxes(false)
    else
        disableACHBoxes(true)

    caw_incChargeSet++;
}

function validateRefundAmount(inputElement, type) {
    var refundValue = parseFloat(inputElement.val()) || 0;
    var originalValue = 0;
    var row = inputElement.closest('tr');
    
    if (type === 'total') {
        // Get original line total from the same row
        var originalElement = row.find('.line_cost .view .woocommerce-Price-amount');
        if (originalElement.length) {
            var originalText = originalElement.text().replace(/[^0-9.-]+/g, '');
            originalValue = parseFloat(originalText) || 0;
        }
    } else if (type === 'tax') {
        // Get original tax amount from the same row
        var originalElement = row.find('.line_tax .view .woocommerce-Price-amount');
        if (originalElement.length) {
            var originalText = originalElement.text().replace(/[^0-9.-]+/g, '');
            originalValue = parseFloat(originalText) || 0;
        }
    }
    
    // If refund amount exceeds original amount, limit it
    if (refundValue > originalValue) {
        inputElement.val(originalValue.toFixed(2));
        inputElement.css('border-color', '#dc3232');
        setTimeout(function() {
            inputElement.css('border-color', '');
        }, 2000);
    }
}

// Simple initialization
function initializeFeeRefundCalculation() {
    
    // Disable fee refund inputs - they should be auto-calculated only
    jQuery('#order_fee_line_items .refund_line_total,#order_fee_line_items .refund_line_tax').prop('readonly', true).css('cursor', 'not-allowed');
    
    // Remove any existing event handlers to prevent duplicates
    jQuery(document).off('change.cawRefund keyup.cawRefund');
    
    // Hook into refund changes with namespaced events to prevent duplicates
    jQuery(document).on('change.cawRefund keyup.cawRefund', '.refund_line_total:not(#order_fee_line_items .refund_line_total)', function() {
        // Prevent recursive calls when we're programmatically updating fee inputs
        if (isUpdatingFeeInputs) {
            return;
        }
        calculateFeeRefunds();
    });
    
    jQuery(document).on('change.cawRefund keyup.cawRefund', '.refund_order_item_qty', function() {
        simpleQuantityValidation(jQuery(this));
        calculateFeeRefunds();
    });
    
    // Initialize when refund button is clicked
    jQuery(document).on('click.cawRefund', '.refund-items', function() {
        setTimeout(function() {
            initializeRefundQuantities();
            makeRefundFieldsReadOnly();
            calculateFeeRefunds();
        }, 500);
    });
    
    // Single initialization check
    setTimeout(function() {
        if (jQuery('.refund_order_item_qty').length > 0) {
            initializeRefundQuantities();
            makeRefundFieldsReadOnly();
            calculateFeeRefunds();
        }
    }, 1000);
}

// Debounce timer for fee calculations
var feeCalculationTimeout = null;
var isCalculating = false;
var isUpdatingFeeInputs = false;

// Calculate fee refunds based on product refunds
function calculateFeeRefunds() {
    if (jQuery('.refund_order_item_qty').length === 0) {
        return;
    }
    
    // Clear any existing timeout to prevent duplicate calculations
    if (feeCalculationTimeout) {
        clearTimeout(feeCalculationTimeout);
    }
    
    // Skip if already calculating
    if (isCalculating) {
        return;
    }
    
    // Debounce the calculation to prevent multiple rapid calls
    feeCalculationTimeout = setTimeout(function() {
        doFeeCalculations();
    }, 200); // Increased timeout for better debouncing
}

// Actual fee calculation logic (debounced)
function doFeeCalculations() {
    
    // Set calculation flag to prevent concurrent executions
    isCalculating = true;
    
    try {
        
        var sfRefundEnabled = false;
        var cfRefundEnabled = false;
    
    if (window.cawRefundSettings && window.cawRefundSettings.paymentMethod) {
        if (window.cawRefundSettings.paymentMethod === 'credit') {
            // Credit card payment - use CC settings
            sfRefundEnabled = window.cawRefundSettings.creditRefundServiceFee;
            cfRefundEnabled = window.cawRefundSettings.creditRefundConvenienceFee;
        } else if (window.cawRefundSettings.paymentMethod === 'ach') {
            // ACH payment - use ACH settings
            sfRefundEnabled = window.cawRefundSettings.achRefundServiceFee;
            cfRefundEnabled = window.cawRefundSettings.achRefundConvenienceFee;
        } else {
            // Fallback: detect from fee names
            var feeNamesText = jQuery('#order_fee_line_items tr[data-order_item_id]').find('.name .view').text();
            var hasCC = feeNamesText.includes('_CC');
            var hasACH = feeNamesText.includes('_ACH');
            
            if (hasCC) {
                sfRefundEnabled = window.cawRefundSettings.creditRefundServiceFee;
                cfRefundEnabled = window.cawRefundSettings.creditRefundConvenienceFee;
            } else if (hasACH) {
                sfRefundEnabled = window.cawRefundSettings.achRefundServiceFee;
                cfRefundEnabled = window.cawRefundSettings.achRefundConvenienceFee;
            }
        }
    }
    
    var originalTotalItemsValue = 0;
    var currentRefundItemsValue = 0;
    
    // Calculate ORIGINAL total and CURRENT refund amounts for proper SF ratio
    jQuery('#order_line_items tr[data-order_item_id]').each(function() {
        var row = jQuery(this);
        var $qtyField = row.find('.refund_order_item_qty');
        
        if ($qtyField.prop('disabled')) return; // Skip fully refunded items
        
        // Get original item total (for ratio calculation)
        var itemTotalText = row.find('.line_cost .view .woocommerce-Price-amount').text();
        var originalItemTotal = parseFloat(itemTotalText.replace(/[^\d.-]/g, '')) || 0;
        originalTotalItemsValue += originalItemTotal;
        
        // Get current additional refund amount being processed now
        var currentRefundQty = parseInt($qtyField.val()) || 0;
        if (currentRefundQty > 0) {
            var originalQty = parseInt(row.find('.quantity .view').text().match(/×\s*(\d+)/)?.[1]) || 1;
            var unitPrice = originalItemTotal / originalQty;
            var currentRefundAmount = unitPrice * currentRefundQty;
            currentRefundItemsValue += currentRefundAmount;
        }
        
    });
    
    if (originalTotalItemsValue > 0 && currentRefundItemsValue > 0) {
        // Calculate SF ratio based on current refund vs original order total
        var sfRefundRatio = currentRefundItemsValue / originalTotalItemsValue;
        
        jQuery('#order_fee_line_items tr[data-order_item_id]').each(function(index) {
            var feeRow = jQuery(this);
            var feeName = feeRow.find('.name .view').text().trim();
            var feeItemId = feeRow.attr('data-order_item_id');
            
            // Enhanced fee detection - get more context about this fee
            var feeAmount = parseFloat(feeRow.find('.line_cost .view .woocommerce-Price-amount').first().text().replace(/[^\d.-]/g, '')) || 0;
            
            // Check for metadata in hidden inputs or data attributes
            var feeTypeFromMeta = null;
            
            // Method 1: Look for fee metadata in form inputs
            var feeMetaInputs = jQuery('input[name*="[' + feeItemId + ']"]');
            feeMetaInputs.each(function() {
                var inputName = jQuery(this).attr('name');
                var inputValue = jQuery(this).val();
                if (inputName && inputName.includes('_fee_type')) {
                    feeTypeFromMeta = inputValue;
                }
            });
            
            // Method 2: Check if fee type info was passed from PHP
            if (!feeTypeFromMeta && window.cawRefundSettings && window.cawRefundSettings.feeTypes) {
                feeTypeFromMeta = window.cawRefundSettings.feeTypes[feeItemId];
            }
            
            // Try to determine fee type by metadata first, then fallback to patterns
            var isServiceFee = false;
            var isConvenienceFee = false;
            
            // Priority 1: Use metadata if available
            if (feeTypeFromMeta) {
                var feeTypeLower = feeTypeFromMeta.toLowerCase();
                if (feeTypeLower === 'service' || feeTypeLower === 'sf' || 
                    feeTypeLower === 'service_fee' || feeTypeLower === 'credit_service_fee' || 
                    feeTypeLower === 'ach_service_fee') {
                    isServiceFee = true;
                } else if (feeTypeLower === 'convenience' || feeTypeLower === 'cf' || 
                           feeTypeLower === 'convenience_fee' || feeTypeLower === 'credit_convenience_fee' || 
                           feeTypeLower === 'ach_convenience_fee') {
                    isConvenienceFee = true;
                }
            }
            
            // Priority 2: Check fee names (existing logic) 
            if (!isServiceFee && !isConvenienceFee) {
                if (feeName.includes('SF_CC') || feeName.toLowerCase().includes('service')) {
                    isServiceFee = true;
                } else if (feeName.includes('CF_CC') || feeName.toLowerCase().includes('convenience')) {
                    isConvenienceFee = true;
                }
            }
            
            // Priority 3: Fallback - detect by position and amount (typically SF is smaller, CF is larger)
            if (!isServiceFee && !isConvenienceFee) {
                var allFees = jQuery('#order_fee_line_items tr[data-order_item_id]');
                
                if (allFees.length === 2) {
                    // If we have exactly 2 fees, assume smaller amount = SF, larger = CF
                    var otherFeeAmount = 0;
                    allFees.each(function(otherIndex) {
                        if (otherIndex !== index) {
                            otherFeeAmount = parseFloat(jQuery(this).find('.line_cost .view .woocommerce-Price-amount').first().text().replace(/[^\d.-]/g, '')) || 0;
                        }
                    });
                    
                    if (feeAmount < otherFeeAmount) {
                        isServiceFee = true;
                    } else if (feeAmount > otherFeeAmount) {
                        isConvenienceFee = true;
                    } else {
                        // If amounts are equal, use position (first = SF, second = CF)
                        if (index === 0) {
                            isServiceFee = true;
                        } else {
                            isConvenienceFee = true;
                        }
                    }
                } else if (allFees.length === 1) {
                    // If there's only one fee, assume it's a service fee (more common)
                    isServiceFee = true;
                }
            }
            
            // Use the fee amount we already parsed
            var originalFeeAmount = feeAmount;
            
            // Get already refunded fee amount
            var refundedFeeAmount = 0;
            var refundedFeeElement = feeRow.find('.line_cost .view .refunded .woocommerce-Price-amount');
            if (refundedFeeElement.length) {
                refundedFeeAmount = Math.abs(parseFloat(refundedFeeElement.text().replace(/[^\d.-]/g, ''))) || 0;
            }
            
            // Calculate remaining refundable fee amount
            var remainingFeeAmount = originalFeeAmount - refundedFeeAmount;
            
            var calculatedFeeRefund = 0;
            
            // Calculate refund based on detected fee type
            if (isServiceFee) {
                // Service fee: proportional to current refund based on ORIGINAL amounts
                if (remainingFeeAmount > 0.01 && sfRefundEnabled) {
                    // Calculate proportional SF based on current refund vs original order total
                    var proportionalSfAmount = originalFeeAmount * sfRefundRatio;
                    // But don't exceed remaining refundable SF amount
                    calculatedFeeRefund = Math.min(proportionalSfAmount, remainingFeeAmount);
                }
            } else if (isConvenienceFee) {
                // Convenience fee: include when this refund will exhaust all remaining items
                if (remainingFeeAmount > 0.01 && cfRefundEnabled) {
                    
                    // Check if ALL remaining refundable items are being refunded to maximum
                    var allItemsMaxedOut = true;
                    var hasRefundableItems = false;
                    
                    jQuery('#order_line_items tr[data-order_item_id]').each(function() {
                        var itemRow = jQuery(this);
                        var itemQtyField = itemRow.find('.refund_order_item_qty');
                        
                        if (itemQtyField.prop('disabled')) return; // Skip fully refunded items
                        
                        hasRefundableItems = true;
                        
                        var currentRefundQty = parseInt(itemQtyField.val()) || 0;
                        var maxRefundQty = parseInt(itemQtyField.attr('max')) || 0;
                        
                        // If this item is not being refunded to its maximum available quantity, CF should not be included
                        if (currentRefundQty < maxRefundQty) {
                            allItemsMaxedOut = false;
                        }
                    });
                    
                    if (allItemsMaxedOut && hasRefundableItems) {
                        calculatedFeeRefund = remainingFeeAmount;
                    }
                }
            }
            
            // Show calculated fee amounts and disable input fields
            var feeRefundInput = feeRow.find('.refund_line_total');
            
            // Set flag to prevent recursive event triggers
            isUpdatingFeeInputs = true;
            
            if (calculatedFeeRefund > 0) {
                feeRefundInput.val(calculatedFeeRefund.toFixed(2));
                feeRefundInput.css('background-color', '#e7f3ff');
            } else {
                feeRefundInput.val('');
                feeRefundInput.css('background-color', '');
            }
            // Always disable fee fields - they should be read-only
            feeRefundInput.prop('readonly', true);
            feeRefundInput.css('cursor', 'not-allowed');
            
            // Clear flag after updating inputs
            isUpdatingFeeInputs = false;
        });
    } else {
        // Set flag to prevent recursive event triggers while clearing
        isUpdatingFeeInputs = true;
        // Clear all fee refunds and disable fields
        jQuery('#order_fee_line_items .refund_line_total').val('').css('background-color', '').prop('readonly', true).css('cursor', 'not-allowed');
        // Clear flag after updating inputs
        isUpdatingFeeInputs = false;
    }
    
    // Trigger WooCommerce to recalculate the total refund amount
    // This will include: product amounts + taxes + SF + CF
    updateRefundTotal();
    
    // Trigger WooCommerce body event without triggering our change handlers
    jQuery('body').trigger('wc_order_update_refund_total');
    
    } finally {
        // Always reset the calculation flag
        isCalculating = false;
    }
}

// Update the total refund amount to include: Products + Taxes + SF + CF
function updateRefundTotal() {
    var totalRefundAmount = 0;
    
    // Add product refund amounts
    jQuery('#order_line_items .refund_line_total').each(function() {
        var amount = parseFloat(jQuery(this).val()) || 0;
        totalRefundAmount += amount;
    });
    
    // Add tax refund amounts
    jQuery('#order_line_items .refund_line_tax').each(function() {
        var amount = parseFloat(jQuery(this).val()) || 0;
        totalRefundAmount += amount;
    });
    
    // Add fee refund amounts (SF + CF)
    jQuery('#order_fee_line_items .refund_line_total').each(function() {
        var amount = parseFloat(jQuery(this).val()) || 0;
        totalRefundAmount += amount;
    });
    
    // Add shipping refund amounts
    jQuery('#order_shipping_line_items .refund_line_total').each(function() {
        var amount = parseFloat(jQuery(this).val()) || 0;
        totalRefundAmount += amount;
    });
    
    // Update the main refund amount field
    jQuery('#refund_amount').val(totalRefundAmount.toFixed(2));
    
    // Update the refund button text to show the amount
    var currencySymbol = jQuery('.woocommerce-Price-currencySymbol').first().text() || '$';
    jQuery('.do-api-refund .wc-order-refund-amount, .do-manual-refund .wc-order-refund-amount')
        .html('<span class="woocommerce-Price-amount amount">' + 
              '<span class="woocommerce-Price-currencySymbol">' + currencySymbol + '</span>' + 
              totalRefundAmount.toFixed(2) + '</span>');
}

// Make refund amount fields read-only (only allow quantity editing)
function makeRefundFieldsReadOnly() {
    
    // Make product refund amount fields read-only
    jQuery('#order_line_items .refund_line_total').each(function() {
        var $field = jQuery(this);
        if (!$field.prop('readonly')) {
            $field.prop('readonly', true);
            $field.css('background-color', '#f6f7f7');
            
            // Add helper text if not already there
            if (!$field.siblings('.caw-helper').length) {
                $field.after('<small class="caw-helper" style="color: #007cba; display: block; font-size: 11px;">Auto-calculated from quantity</small>');
            }
        }
    });
    
    // Also make tax fields read-only
    jQuery('#order_line_items .refund_line_tax').each(function() {
        var $field = jQuery(this);
        if (!$field.prop('readonly')) {
            $field.prop('readonly', true);
            $field.css('background-color', '#f6f7f7');
        }
    });
}

// Quantity validation using min/max attributes
function simpleQuantityValidation($input) {
    var enteredQty = parseInt($input.val()) || 0;
    var minQty = parseInt($input.attr('min')) || 0;
    var maxQty = parseInt($input.attr('max')) || 999;
    var $row = $input.closest('tr');
    
    // Check constraints and correct if needed
    var corrected = false;
    if (enteredQty < minQty) {
        $input.val(minQty);
        corrected = true;
        enteredQty = minQty;
    } else if (enteredQty > maxQty) {
        $input.val(maxQty);
        corrected = true;
        enteredQty = maxQty;
    }
    
    // Show visual feedback if corrected
    if (corrected) {
        $input.css('border-color', '#dc3232');
        setTimeout(function() { $input.css('border-color', ''); }, 2000);
    }
    
    // Auto-calculate amount and tax based on the additional quantity to refund
    if (enteredQty > 0) {
        // enteredQty is now the ADDITIONAL quantity to refund in this request
        var additionalQtyToRefund = enteredQty;
        
        // Get original amounts per unit
        var originalTotal = parseFloat($row.find('.line_cost .view .woocommerce-Price-amount').first().text().replace(/[^\d.-]/g, '')) || 0;
        var originalQty = parseInt($row.find('.quantity .view').text().match(/×\s*(\d+)/)?.[1]) || 1;
        var unitPrice = originalTotal / originalQty;
        
        // Calculate refund amount for the additional quantity being refunded
        var refundAmount = unitPrice * additionalQtyToRefund;
        $row.find('.refund_line_total').val(refundAmount.toFixed(2));
        
        // Calculate proportional tax if there is any
        var $taxElement = $row.find('.line_tax .view .woocommerce-Price-amount').first();
        if ($taxElement.length) {
            var originalTax = parseFloat($taxElement.text().replace(/[^\d.-]/g, '')) || 0;
            var unitTax = originalTax / originalQty;
            var refundTax = unitTax * additionalQtyToRefund;
            $row.find('.refund_line_tax').val(refundTax.toFixed(2));
        }
        
    } else {
        // No additional refund for this request
        $row.find('.refund_line_total').val('');
        $row.find('.refund_line_tax').val('');
    }
    
    // Update total refund amount after product amounts change
    setTimeout(function() {
        updateRefundTotal();
    }, 10);
}

// Initialize refund quantities with proper remaining refundable logic
function initializeRefundQuantities() {
    jQuery('#order_line_items tr[data-order_item_id]').each(function() {
        var $row = jQuery(this);
        var quantityText = $row.find('.quantity .view').text();
        var originalQty = parseInt(quantityText.match(/×\s*(\d+)/)?.[1]) || 1;
        
        // Check for already refunded quantity
        var alreadyRefundedQty = 0;
        var refundedSpan = $row.find('.quantity .view .refunded');
        if (refundedSpan.length) {
            alreadyRefundedQty = Math.abs(parseInt(refundedSpan.text())) || 0;
        }
        
        // Calculate remaining refundable quantity (n - m)
        var remainingRefundable = originalQty - alreadyRefundedQty;
        
        var $qtyField = $row.find('.refund_order_item_qty');
        
        if (remainingRefundable <= 0) {
            // Fully refunded - no more refunds possible
            $qtyField.val(0).attr('min', 0).attr('max', 0).prop('disabled', true);
        } else {
            // Can refund from 0 to remainingRefundable additional items
            $qtyField.val(0).attr('min', 0).attr('max', remainingRefundable).prop('disabled', false);
            
            // Store original and already refunded for calculations
            $qtyField.attr('data-original-qty', originalQty);
            $qtyField.attr('data-already-refunded', alreadyRefundedQty);
        }
        
        // Clear amount fields initially
        $row.find('.refund_line_total, .refund_line_tax').val('');
    });
    
    // Update total refund amount after initialization
    setTimeout(function() {
        updateRefundTotal();
    }, 10);
}