﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.IO;


namespace SideBySideIntegrationTestApplication
{

	public partial class ClientForm : Form
	{
		public ClientForm()
		{
			InitializeComponent();
		}

		private const int PORTNUMBER = 13000;
		private const byte stx = 0x02;
		private const byte etx = 0x03;
		private const String TRANSACTION_TYPE = "transactionType";
		private const String TENDER_TYPE = "tenderType";
		private const String SALE_AMT = "saleAmount";
		private const String CLERK_NUM = "clerkNumber";
		private const String INVOICE_NUM = "invoiceNumber";
		private const String CUST_NUM = "customerNumber";
		private const String TAX_AMT = "taxAmount";
		private const String TIP_AMT = "tipAmount";
		private const String SERVICE_FEE_AMT = "serviceFeeAmount";
		private const String SERVICE_FEE_LABEL = "serviceFeeLabel";
		private const String CASHBACK_AMT = "cashBackAmount";
		private const String ORIG_GATEWAY_REF = "origGateWayRef";
		private const String ORIG_AMT = "origAmt";
		private const String ORIG_APPROVAL_CODE = "origApprovalCode";
		private const String ORIG_TRANS_TYPE = "origTransType";
		private const String ORIG_TRANS_ID = "origTransID";
		private const String APPROVAL_CODE = "approvalCode";
		private const String CA_APPROVED = "000";
		private const String CA_APPROVED_PARTIAL = "010";

		private const String preString = "ChargeanywhereTransactionResult://?";
		/* Old Transacctions Types
		private const string SALE_TRANSACTION_TYPE = "1";
		// private const string DEBIT_TRANSACTION_TYPE = "2";
		private const string AUTH_TRANSACTION_TYPE = "3";
		private const string FORCE_TRANSACTION_TYPE = "4";
		private const string VOID_TRANSACTION_TYPE = "5";
		private const string RETURN_TRANSACTION_TYPE = "6";
		private const string REVERSAL_TRANSACTION_TYPE = "11";
		//private const string DEBIT_RETURN_TRANSACTION_TYPE = "7";
		*/

		private const string SALE_TRANSACTION_TYPE = "1";
		private const string AUTH_TRANSACTION_TYPE = "6";
		private const string FORCE_TRANSACTION_TYPE = "4";
		private const string VOID_TRANSACTION_TYPE = "2";
		private const string RETURN_TRANSACTION_TYPE = "3";
		private const string REVERSAL_TRANSACTION_TYPE = "11";
		private const string BALANCEINQUIRY_TRANSACTION_TYPE = "14";
		private const string ACTIVATE_TRANSACTION_TYPE = "21";
		private const string ADDVALUE_TRANSACTION_TYPE = "22";
		private const string DEACTIVATE_TRANSACTION_TYPE = "23";
		private const string UNLOAD_TRANSACTION_TYPE = "24";

		/* Old Tender Types
		private const int TENDERTYPE_ACH = 1;
		private const int TENDERTYPE_CASH = 2;
		private const int TENDERTYPE_CHECK = 3;
		private const int TENDERTYPE_CREDIT = 4;
		private const int TENDERTYPE_GIFT = 5;
		private const int TENDERTYPE_DEBIT = 6;
		private const int TENDERTYPE_EBT_CASH = 7;
		private const int TENDERTYPE_EBT_FOODSTAMP = 8;
		private const int TENDERTYPE_TPAGO = 9;
		*/
		private const int TENDERTYPE_ACH = 3;
		private const int TENDERTYPE_CASH = 5;
		private const int TENDERTYPE_CHECK = 1;
		private const int TENDERTYPE_CREDIT = 2;
		private const int TENDERTYPE_GIFT = 4;
		private const int TENDERTYPE_DEBIT = 6;
		private const int TENDERTYPE_EBT_CASH = 7;
		private const int TENDERTYPE_EBT_FOODSTAMP = 8;
		private const int TENDERTYPE_TPAGO = 9;

		private const int TENDERTYPE_MAXNUM = 10;
		private System.Collections.ArrayList panels;
		int currentPanelIndex = 0;

		private String OriginalGatewayReferenceNumber = "";


		private string transType;
		private List<TransactionResult> transList = new List<TransactionResult>();

		private byte[] WrapString(string send)
		{
			int length = send.Length;
			byte[] data = new byte[length + 2];
			data[0] = stx;
			data[length + 1] = etx;
			Array.Copy(System.Text.Encoding.ASCII.GetBytes(send), 0, data, 1, length);
			return data;
		}

		private String getTenderType()
		{
			if (radioButtonCredit.Checked)
				return TENDERTYPE_CREDIT.ToString();
			else if (radioButtonDebit.Checked)
				return TENDERTYPE_DEBIT.ToString();
			else if (radioButtonEbtCash.Checked)
				return TENDERTYPE_EBT_CASH.ToString();
			else if (radioButtonEbtFoodStamp.Checked)
				return TENDERTYPE_EBT_FOODSTAMP.ToString();
			else if (radioButtonGift.Checked)
				return TENDERTYPE_GIFT.ToString();
			else if (radioButtonCash.Checked)
				return TENDERTYPE_CASH.ToString();
			else if (radioButtonCheck.Checked)
				return TENDERTYPE_CHECK.ToString();
			else if (radioButtonAch.Checked)
				return TENDERTYPE_ACH.ToString();

			return TENDERTYPE_CREDIT.ToString();
		}

		private bool isDebitTransaction()
		{
			return radioButtonDebit.Checked || radioButtonEbtCash.Checked;
		}

		private bool isTransactionReversable()
		{
			if (radioButtonSaleAndVoid.Checked ||
				radioButtonAuthForce.Checked ||
				radioButtonReversal.Checked ||
				radioButtonAuthForceTip.Checked ||
				radioButtonAuthEditTip.Checked ||
				radioButtonReturnSale.Checked ||
				radioButtonForceReturn.Checked ||
				radioButtonForceReversal.Checked)
			{
				return true;
			}
			return false;
		}

		private void SendReceive(String dataToSend, bool save)
		{
			byte[] bytes = new byte[8192];
			try
			{
				// Establish the remote endpoint for the socket.

				IPHostEntry ipHostInfo = Dns.GetHostEntry(Dns.GetHostName());

				IPAddress ipAddress = IPAddress.Parse(textBoxIP.Text);
				//  IPAddress ipAddress = new IPAddress(new byte[] { 127, 0, 0, 1 });
				IPEndPoint remoteEP = new IPEndPoint(ipAddress, PORTNUMBER);

				// Create a TCP/IP  socket.
				Socket sender = new Socket(ipAddress.AddressFamily,
										SocketType.Stream, ProtocolType.Tcp);

				// Connect the socket to the remote endpoint. Catch any errors.
				try
				{
					sender.Connect(remoteEP);

					Console.WriteLine("Socket connected to {0}",
							sender.RemoteEndPoint.ToString());
					byte[] msg = WrapString(dataToSend);

					// Send the data through the socket.
					int bytesSent = sender.Send(msg);

					// Receive the response from the remote device.
					int bytesRec = sender.Receive(bytes);

					String dataRec = getPayload(bytes, bytesRec);
					if (dataRec == null)
						dataRec = "";

					Console.WriteLine("Data received = {0}",
							dataRec);
					parseDataAndShowForm(dataRec, save);
					// Release the socket.
					sender.Shutdown(SocketShutdown.Both);
					sender.Close();
				}
				catch (ArgumentNullException ane)
				{
					Console.WriteLine("ArgumentNullException : {0}", ane.ToString());
					MessageBox.Show("Error in sending data:" + ane.Message);
				}
				catch (SocketException se)
				{
					Console.WriteLine("SocketException : {0}", se.ToString());
					MessageBox.Show("Error in sending data:" + se.Message);
				}
				catch (Exception ee)
				{
					Console.WriteLine("Unexpected exception : {0}", ee.ToString());
					MessageBox.Show("Error in sending data:" + ee.Message);
				}

			}
			catch (Exception ex)
			{
				Console.WriteLine(ex.ToString());
				MessageBox.Show("Error in sending data:" + ex.Message);
			}
		}

		private void buttonSend_Click()
		{


			if (isTransactionReversable())
			{

				bool found = false;
				if (listViewTrans.Items.Count == 0)
				{
					MessageBox.Show("Please perform " + (radioButtonAuth.Checked ? "Auth" : "Sale"));
					return;
				}

				if (listViewTrans.SelectedItems == null)
				{
					MessageBox.Show("Please Selected Items");
					return;
				}
				String transID = "";
				foreach (ListViewItem item in listViewTrans.SelectedItems)
				{
					transID = item.Text;
				}

				foreach (TransactionResult transaction in transList)
				{
					if (radioButtonSaleAndVoid.Checked || radioButtonReversal.Checked || radioButtonForceReversal.Checked)
					{ // check for Sale transations{
						if ((transaction.TransType.Equals(SALE_TRANSACTION_TYPE) || (transaction.TransType.Equals(RETURN_TRANSACTION_TYPE) || transaction.TransType.Equals(FORCE_TRANSACTION_TYPE)) && transaction.TransactionId.Equals(transID)))
						{
							performTrans(transaction);
							transList.Remove(transaction);
							found = true;
							break;
						}
					}
					else
					{
						if (transaction.TransType.Equals(AUTH_TRANSACTION_TYPE) && transaction.TransactionId.Equals(transID) && radioButtonAuthForce.Checked)
						{
							performTrans(transaction);
							transList.Remove(transaction);
							found = true;
							break;
						}

						if (transaction.TransType.Equals(AUTH_TRANSACTION_TYPE) && transaction.TransactionId.Equals(transID) && radioButtonAuthForceTip.Checked)
						{
							string value = "0.00";
							if (InputDialog.InputBox("Enter Tip", "Tip:", ref value) == DialogResult.OK)
							{
								transaction.TipAmount = value;
							}

							performTrans(transaction);
							transList.Remove(transaction);
							found = true;
							break;
						}

						if (transaction.TransType.Equals(FORCE_TRANSACTION_TYPE) && transaction.TransactionId.Equals(transID) && radioButtonAuthEditTip.Checked)
						{
							//transaction.AuthorizedAmount -= transaction.TipAmount;

							string value = "0.00";
							String tipToEdit = transaction.TipAmount;
							if (InputDialog.InputBox("Enter Tip Amount:", "Amount:", ref value) == DialogResult.OK)
							{
								transaction.TipAmount = value;
							}

							double newAuthorizedAmount = Double.Parse(transaction.AuthorizedAmount) - Double.Parse(tipToEdit);
							transaction.AuthorizedAmount = newAuthorizedAmount.ToString();

							performTrans(transaction);
							transList.Remove(transaction);
							found = true;
							break;
						}


						if ((transaction.TransType.Equals(SALE_TRANSACTION_TYPE) || transaction.TransType.Equals(FORCE_TRANSACTION_TYPE)) && transaction.TransactionId.Equals(transID) && (radioButtonReturnSale.Checked || radioButtonForceReturn.Checked))
						{
							string value = "0.00";
							if (InputDialog.InputBox("Enter Return Amount:", "Amount:", ref value) == DialogResult.OK)
							{
								transaction.ReturnAmount = value;
							}

							performTrans(transaction);
							transList.Remove(transaction);
							found = true;
							break;
						}
					}
				}

				if (!found)
				{
					MessageBox.Show("Please perform " + (radioButtonSaleAndVoid.Checked ? "Sale" : "Auth"));
				}

				return;
			}

			if (radioButtonForceApprovalCode.Checked && textBoxApprovalCode.Text.Length != 6)
			{
				MessageBox.Show("Approval code should have length 6");
				return;
			}



			byte[] bytes = new byte[1024];

			try
			{
				// Establish the remote endpoint for the socket.

				IPHostEntry ipHostInfo = Dns.GetHostEntry(Dns.GetHostName());

				IPAddress ipAddress = IPAddress.Parse(textBoxIP.Text);
				//  IPAddress ipAddress = new IPAddress(new byte[] { 127, 0, 0, 1 });
				IPEndPoint remoteEP = new IPEndPoint(ipAddress, PORTNUMBER);

				// Create a TCP/IP  socket.
				Socket sender = new Socket(ipAddress.AddressFamily,
										SocketType.Stream, ProtocolType.Tcp);

				// Connect the socket to the remote endpoint. Catch any errors.
				try
				{
					sender.Connect(remoteEP);

					Console.WriteLine("Socket connected to {0}",
							sender.RemoteEndPoint.ToString());

					dataToSend = @"ChargeanywhereProcessTransaction://?";
					dataToSend += "version=1.0&";
					if (radioButtonSale.Checked)
						transType = SALE_TRANSACTION_TYPE;
					else if (radioButtonReturn.Checked)
						transType = RETURN_TRANSACTION_TYPE;
					else if (radioButtonSaleAndVoid.Checked)
						transType = VOID_TRANSACTION_TYPE;
					else if (radioButtonForceApprovalCode.Checked)
						transType = FORCE_TRANSACTION_TYPE;
					else if (radioButtonAuth.Checked)
						transType = AUTH_TRANSACTION_TYPE;
					else if (radioButtonAuth.Checked)
						transType = AUTH_TRANSACTION_TYPE;
					else if (radioButtonBalanceInquiry.Checked)
						transType = BALANCEINQUIRY_TRANSACTION_TYPE;
					else if (radioButtonActivate.Checked)
						transType = ACTIVATE_TRANSACTION_TYPE;
					else if (radioButtonAddValue.Checked)
						transType = ADDVALUE_TRANSACTION_TYPE;
					else if (radioButtonDeactivate.Checked)
						transType = DEACTIVATE_TRANSACTION_TYPE;
					else if (radioButtonUnloadValue.Checked)
						transType = UNLOAD_TRANSACTION_TYPE;
					if (radioButtonReversal.Checked)
						transType = REVERSAL_TRANSACTION_TYPE;
					dataToSend += TRANSACTION_TYPE + "=" + transType;

					dataToSend += "&" + TENDER_TYPE + "=" + getTenderType();

					if(!radioButtonBalanceInquiry.Checked && !radioButtonDeactivate.Checked)
						dataToSend += "&" + SALE_AMT + "=" + textBoxAmount.Text;
					if (textBoxTaxAmount.Text != "")
						dataToSend += "&" + TAX_AMT + "=" + textBoxTaxAmount.Text;
					if (!radioButtonAuthForce.Checked) //Send the tip amount with Force
						dataToSend += "&" + TIP_AMT + "=" + textBoxTip.Text;
					if (textBoxServiceFeeLabel.Text != "")
						dataToSend += "&" + SERVICE_FEE_LABEL + "=" + textBoxServiceFeeLabel.Text;
					if (textBoxServiceFeeAmount.Text != "")
						dataToSend += "&" + SERVICE_FEE_AMT + "=" + textBoxServiceFeeAmount.Text;
					if (textBoxCashBack.Text.Length > 0 && isDebitTransaction())
						dataToSend += "&" + CASHBACK_AMT + "=" + textBoxCashBack.Text;

					dataToSend += "&" + CLERK_NUM + "=" + textBoxClerk.Text;
					dataToSend += "&" + INVOICE_NUM + "=" + textBoxInvoice.Text;
					dataToSend += "&" + CUST_NUM + "=" + textBoxCustomer.Text;

					if (radioButtonForceApprovalCode.Checked)
						dataToSend += "&" + APPROVAL_CODE + "=" + textBoxApprovalCode.Text;

					byte[] msg = WrapString(dataToSend);

					// Send the data through the socket.
					int bytesSent = sender.Send(msg);

					// Receive the response from the remote device.
					int bytesRec = sender.Receive(bytes);

					String dataRec = getPayload(bytes, bytesRec);

					Console.WriteLine("Data received = {0}",
							dataRec);
					parseDataAndShowForm(dataRec);
					// Release the socket.
					sender.Shutdown(SocketShutdown.Both);
					sender.Close();

				}
				catch (ArgumentNullException ane)
				{
					Console.WriteLine("ArgumentNullException : {0}", ane.ToString());
					MessageBox.Show("Error in sending data:" + ane.Message);
				}
				catch (SocketException se)
				{
					Console.WriteLine("SocketException : {0}", se.ToString());
					MessageBox.Show("Error in sending data:" + se.Message);
				}
				catch (Exception ee)
				{
					Console.WriteLine("Unexpected exception : {0}", ee.ToString());
					MessageBox.Show("Error in sending data:" + ee.Message);
				}

			}
			catch (Exception ex)
			{
				Console.WriteLine(ex.ToString());
				MessageBox.Show("Error in sending data:" + ex.Message);
			}
		}

		private bool parseDataAndShowForm(String dataReceived)
		{
			return parseDataAndShowForm(dataReceived, true);
		}

		private bool parseDataAndShowForm(String dataReceived, bool save)
		{
			if (null == dataReceived)
				return false;

			if (!dataReceived.StartsWith(preString))
				return false;

			dataReceived = dataReceived.Substring(preString.Length);

			String[] dataElements = dataReceived.Split('&');

			if (dataElements.Length > 1 && (radioButtonSale.Checked || radioButtonReturn.Checked || radioButtonAuth.Checked || radioButtonForceApprovalCode.Checked || radioButtonAuthForce.Checked || radioButtonAuthForceTip.Checked))
			{
				if (save)
					saveTransaction(dataElements);
			}

			String dataToShow = "";
			foreach (String elem in dataElements)
			{
				dataToShow += elem;
				dataToShow += System.Environment.NewLine;
			}

			Console.WriteLine("Setting textField:" + dataToShow);

			textBoxResult.Text = "Data Sent: \r\n" + dataToSend + "\r\n\r\n";
			textBoxResult.Text += "Data Received: \r\n" + dataReceived + "\r\n\r\n";
			textBoxResult.Text += "Details: \r\n" + dataToShow;

			return true;
		}

		private void saveTransaction(String[] dataElements)
		{
			TransactionResult trans = new TransactionResult();
			trans.OriginalGatewayReferenceNumber = OriginalGatewayReferenceNumber;

			foreach (String elem in dataElements)
			{
				String[] transData1 = elem.Split('=');
				if (transData1.Length == 2)
				{
					if (transData1[0].Equals(TransactionResult.CARD_NUM))
					{
						trans.CardNum = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.NAME_ON_CARD))
					{
						trans.NameOnCard = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.RESPONSE_CODE))
					{
						trans.ResponseCode = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.PROCESSOR_RESPONSE_CODE))
					{
						trans.ProcessorResponseCode = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.RESPONSE_CODE))
					{
						trans.ResponseCode = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.CVV_RESPONSE))
					{
						trans.CvvResponse = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.AVS_RESPONSE))
					{
						trans.AvsResponse = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.APPROVAL_CODE))
					{
						trans.ApprovalCode = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.TRANSACTION_ID))
					{
						trans.TransactionId = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.GATEWAY_REF))
					{
						trans.GatewayReferenceNumber = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.PROCESSOR_REF))
					{
						trans.ProcessReferenceNumber = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.AUTHORIZED_AMT))
					{
						trans.AuthorizedAmount = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.TRANSACTION_TYPE))
					{
						//trans.TransType = transData1[1];
						trans.TransType = transType;
					}
					else if (transData1[0].Equals(TransactionResult.TENDER_TYPE))
					{
						trans.TenderType = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.TAX_AMOUNT))
					{
						trans.TaxAmount = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.TIP_AMOUNT))
					{
						trans.TipAmount = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.CASHBACK_AMOUNT))
					{
						trans.CashBackAmount = transData1[1];
					}
					else if (transData1[0].Equals(TransactionResult.SWIPEFEE_AMOUNT))
					{
						trans.SwipeFeeAmount = transData1[1];
					}
				}
			}

			if (trans.ResponseCode.Equals(CA_APPROVED) || trans.ResponseCode.Equals(CA_APPROVED_PARTIAL))
			{
				transList.Add(trans);
			}

		}

		private String getDataToSend(TransactionResult transResultData)
		{

			String dataToSend = @"ChargeanywhereProcessTransaction://?";
			dataToSend += "version=1.0&";

			if (radioButtonSaleAndVoid.Checked)
			{
				transType = VOID_TRANSACTION_TYPE;
				dataToSend += TRANSACTION_TYPE + "=" + VOID_TRANSACTION_TYPE;
			}
			else if (radioButtonReversal.Checked || radioButtonForceReversal.Checked)
			{
				transType = REVERSAL_TRANSACTION_TYPE;
				dataToSend += TRANSACTION_TYPE + "=" + REVERSAL_TRANSACTION_TYPE;
			}
			else if (radioButtonAuthForce.Checked || radioButtonAuthEditTip.Checked)
      {
        transType = FORCE_TRANSACTION_TYPE;
        dataToSend += TRANSACTION_TYPE + "=" + FORCE_TRANSACTION_TYPE;
      }
			else if (radioButtonAuthForceTip.Checked)
      {
        transType = FORCE_TRANSACTION_TYPE;
        dataToSend += TRANSACTION_TYPE + "=" + FORCE_TRANSACTION_TYPE;
      }
      else if (radioButtonReturnSale.Checked || radioButtonForceReturn.Checked)
      {
        transType = RETURN_TRANSACTION_TYPE;
        dataToSend += TRANSACTION_TYPE + "=" + RETURN_TRANSACTION_TYPE;
      }


      transType = dataToSend.Substring(dataToSend.IndexOf('?') + 1);

      dataToSend += "&" + TENDER_TYPE + "=" + transResultData.TenderType;
      //    dataToSend += "&" + SALE_AMT + "=" + textBoxAmount.Text;
      //     dataToSend += "&" + CLERK_NUM + "=" + textBoxClerk.Text;
      //     dataToSend += "&" + INVOICE_NUM + "=" + textBoxInvoice.Text;
      //     dataToSend += "&" + CUST_NUM + "=" + textBoxCustomer.Text;
      //     dataToSend += "&" + TIP_AMT + "=" + textBoxTip.Text;
      //     if (radioButtonDebit.Checked)
      //       dataToSend += "&" + CASHBACK_AMT + "=" + textBoxCashBack.Text;
      dataToSend += "&" + ORIG_TRANS_TYPE + "=" + transResultData.TransType;
      //  dataToSend += "&" + ORIG_TRANS_ID + "=" + transResultData.TransactionId;
      dataToSend += "&" + ORIG_APPROVAL_CODE + "=" + transResultData.ApprovalCode;
			if(radioButtonAuthEditTip.Checked)
				dataToSend += "&" + ORIG_GATEWAY_REF + "=" + transResultData.OriginalGatewayReferenceNumber;
			else
				dataToSend += "&" + ORIG_GATEWAY_REF + "=" + transResultData.GatewayReferenceNumber;
			OriginalGatewayReferenceNumber = transResultData.GatewayReferenceNumber;
			dataToSend += "&" + ORIG_AMT + "=" + transResultData.AuthorizedAmount;
      if (radioButtonAuthForceTip.Checked)
        dataToSend += "&" + TIP_AMT + "=" + transResultData.TipAmount;
			if (radioButtonAuthEditTip.Checked)
				dataToSend += "&modifier=6&" + TIP_AMT + "=" + transResultData.TipAmount;

			if (radioButtonReturnSale.Checked || radioButtonForceReturn.Checked)
        dataToSend += "&" + SALE_AMT + "=" + transResultData.ReturnAmount;
      else
        dataToSend += "&" + SALE_AMT + "=" + transResultData.AuthorizedAmount;

      return dataToSend;
    }

    String dataToSend;
    String dataRec;
    private void performTrans(TransactionResult transResultData)
    {
      dataToSend = "";
      dataRec = "";

      byte[] bytes = new byte[1024];
      try
      {
        // Establish the remote endpoint for the socket.
        String dataToSend1 = getDataToSend(transResultData);
      //  MessageBox.Show(dataToSend1);

        IPHostEntry ipHostInfo = Dns.GetHostEntry(Dns.GetHostName());

        IPAddress ipAddress = IPAddress.Parse(textBoxIP.Text);
        //  IPAddress ipAddress = new IPAddress(new byte[] { 127, 0, 0, 1 });
        IPEndPoint remoteEP = new IPEndPoint(ipAddress, PORTNUMBER);

        // Create a TCP/IP  socket.
        Socket sender = new Socket(ipAddress.AddressFamily,
            SocketType.Stream, ProtocolType.Tcp);

        // Connect the socket to the remote endpoint. Catch any errors.
        try
        {
          sender.Connect(remoteEP);

          Console.WriteLine("Socket connected to {0}",
              sender.RemoteEndPoint.ToString());         

          dataToSend = getDataToSend(transResultData);

          byte[] msg = WrapString(dataToSend);

          // Send the data through the socket.
          int bytesSent = sender.Send(msg);

          // Receive the response from the remote device.
          int bytesRec = sender.Receive(bytes);

          dataRec = getPayload(bytes, bytesRec);

          Console.WriteLine("Data received = {0}",
              dataRec);
         
          parseDataAndShowForm(dataRec);
          // Release the socket.
          sender.Shutdown(SocketShutdown.Both);
          sender.Close();

        }
        catch (ArgumentNullException ane)
        {
          Console.WriteLine("ArgumentNullException : {0}", ane.ToString());
          MessageBox.Show("Error in sending data:" + ane.Message);
        }
        catch (SocketException se)
        {
          Console.WriteLine("SocketException : {0}", se.ToString());
          MessageBox.Show("Error in sending data:" + se.Message);
        }
        catch (Exception ee)
        {
          Console.WriteLine("Unexpected exception : {0}", ee.ToString());
          MessageBox.Show("Error in sending data:" + ee.Message);
        }

      }
      catch (Exception ex)
      {
        Console.WriteLine(ex.ToString());
        MessageBox.Show("Error in sending data:" + ex.Message);
      }


    }

    private string getPayload(byte[] receivedBytes, int bytesRec)
    {
      int start = 0;
      int end = 0;
      String retStr = null;
      //find the stx
      for (start = 0; start < bytesRec; start++)
      {
        if (receivedBytes[start] == stx)
          break;
      }

      for (end = start; end < bytesRec; end++)
      {
        if (receivedBytes[end] == etx)
          break;
      }
      if ((end-start) >= 1)
        retStr = Encoding.ASCII.GetString(receivedBytes, start+1, end-start-1);

      return retStr;

    }


    private static String ApplyDollarMask(TextBox textBox, char keyChar)
    {

      String temp = (textBox.SelectionLength > 0 ? textBox.Text.Replace(textBox.SelectedText, "") : textBox.Text);

      if (temp.Length >= textBox.MaxLength && (int)keyChar != 0x08)
      {
        return temp;
      }

      temp = temp.Replace(".", "");

      if ((int)keyChar != 0x08 && (int)keyChar >= (int)'0' && (int)keyChar <= (int)'9')
      {
        temp += keyChar;
      }

      if ((int)keyChar == 0x08 && temp.Length > 0)
      {
        temp = temp.Substring(0, temp.Length - 1);
      }

      if (temp.Length == 0)
      {
        return "0.00";
      }

      ulong amount = ulong.Parse(temp);

      return String.Format("{0:#####0}.{1:00}", (amount / 100), (amount % 100));

    }


    private void FormatAsCurrency(object sender, KeyPressEventArgs e)
    {
      if (!(sender is TextBox))
      {
        return;
      }

      TextBox textBox = ((TextBox)sender);

      if (textBox.ReadOnly)
      {
        return;
      }

      if (e.KeyChar >= '0' && e.KeyChar <= '9' || e.KeyChar == '\b')
      {
        textBox.Text = ApplyDollarMask(textBox, e.KeyChar);
      }

      e.Handled = true;
    }

    private void textBoxAmount_KeyPress(object sender, KeyPressEventArgs e)
    {
      FormatAsCurrency(sender, e);
    }

    private void ClientForm_Load(object sender, EventArgs e)
    {

      panels = new System.Collections.ArrayList();
      panels.Add(panelTransType);
      panels.Add(panelData);
      panels.Add(panelResults);
      currentPanelIndex = 0;
      Panel panel = (Panel)panels[currentPanelIndex];
      panel.BringToFront();

      buttonBack.Visible = false;


      textBoxAmount.Text = "0.00";
    }

    private void buttonBack_Click(object sender, EventArgs e)
    {
      currentPanelIndex--;
      // Panel panel = (Panel)panels[currentPanelIndex];
      // panel.BringToFront();
      updatePanel();
      updateButtons();
    }

    private void updateButtons()
    {
      

      if (currentPanelIndex == 0)
      {
        buttonBack.Visible = false;
        buttonNext.Text = "Next";
      }
      else if (currentPanelIndex == 1)
      {
        buttonBack.Visible = true;
        buttonNext.Text = "Send";
        textBoxResult.Clear();

        textBoxCashBack.Enabled = radioButtonDebit.Checked || radioButtonEbtCash.Checked;
        textBoxApprovalCode.Enabled = radioButtonForceApprovalCode.Checked;
      }
      else
      {
        buttonBack.Visible = false;
        buttonNext.Text = "Restart";
        buttonSend_Click();
      }

     
    }

    private void updatePanel()
    {
      Panel panel = (Panel)panels[currentPanelIndex];
     // if (panel == panelData && (radioButtonSaleAndVoid.Checked || radioButtonAuthForce.Checked || radioButtonAuthForceTip.Checked || radioButtonReversal.Checked || radioButtonReturnSale.Checked))
      if (panel == panelData && (isTransactionReversable()))
       {
        panel = panelList;
        updateList();
      }
      panel.BringToFront();
    }

    private void updateList()
    {
     // listViewTrans.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent);
     // listViewTrans.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);

      listViewTrans.Clear();
      listViewTrans.View = View.Details;
      listViewTrans.Columns.Add("TransID", 80, HorizontalAlignment.Left);
      listViewTrans.Columns.Add("GatewayRef",100, HorizontalAlignment.Left);
      listViewTrans.Columns.Add("ApprovalCode");
      listViewTrans.Columns.Add("Amount");
      listViewTrans.Columns.Add("TransType");
 

      foreach (TransactionResult transaction in transList)
      {
        if (radioButtonSaleAndVoid.Checked || radioButtonReversal.Checked || radioButtonReturnSale.Checked )
        { // check for Sale transations{
          if (transaction.TransType.Equals(SALE_TRANSACTION_TYPE) || transaction.TransType.Equals(RETURN_TRANSACTION_TYPE))
          {
            listViewTrans.Items.Add(new ListViewItem(new string[] { transaction.TransactionId, transaction.GatewayReferenceNumber, transaction.ApprovalCode, transaction.AuthorizedAmount, transaction.TransType }));
            //   listViewTrans.Items.Add(getTransactionData(transaction));
            //  performTrans(transaction);
            //  transList.Remove(transaction);
            //  found = true;
            //  break;
          }
        }
        else
        {
					if ((radioButtonForceReturn.Checked || radioButtonForceReversal.Checked))
					{
						if (transaction.TransType.Equals(FORCE_TRANSACTION_TYPE))
							listViewTrans.Items.Add(new ListViewItem(new string[] { transaction.TransactionId, transaction.GatewayReferenceNumber, transaction.ApprovalCode, transaction.AuthorizedAmount, transaction.TransType }));
					}
					else
					{
						if (transaction.TransType.Equals(AUTH_TRANSACTION_TYPE) && (radioButtonAuthForce.Checked || radioButtonAuthForceTip.Checked))
						{
							listViewTrans.Items.Add(new ListViewItem(new string[] { transaction.TransactionId, transaction.GatewayReferenceNumber, transaction.ApprovalCode, transaction.AuthorizedAmount, transaction.TransType }));
							//listViewTrans.Items.Add(transaction.TransactionId);
							// performTrans(transaction);
							//  transList.Remove(transaction);
							//  found = true;
							//break;
						}
						if (transaction.TransType.Equals(FORCE_TRANSACTION_TYPE) && radioButtonAuthEditTip.Checked)
						{
							listViewTrans.Items.Add(new ListViewItem(new string[] { transaction.TransactionId, transaction.GatewayReferenceNumber, transaction.ApprovalCode, transaction.AuthorizedAmount, transaction.TransType }));
							//listViewTrans.Items.Add(transaction.TransactionId);
							// performTrans(transaction);
							//  transList.Remove(transaction);
							//  found = true;
							//break;
						}
					}

				}
      }
    }

    private String getTransactionData(TransactionResult trans)
    {
      return "TransID:" + trans.TransactionId + "::" + "GateWayRef:" + trans.GatewayReferenceNumber + "::" + "Amount:" + trans.AuthorizedAmount + "::" + "ApprovalCode:" + trans.ApprovalCode + "::" + "TransType:" + trans.TransType;
    }

    private void buttonNext_Click(object sender, EventArgs e)
    {
      if (currentPanelIndex == panels.Count - 1)
        currentPanelIndex = 0;
      else
        currentPanelIndex++;
      updatePanel();
   //   Panel panel = (Panel)panels[currentPanelIndex];
    //  panel.BringToFront();
      updateButtons();

    }

		private void buttonSerialNumber_Click(object sender, EventArgs e)
		{
			dataToSend = @"ChargeanywhereProcessTransaction://?action=1&";
			dataToSend += "version=1.0";
			SendReceive(dataToSend, false);
			panelResults.BringToFront();
			currentPanelIndex = 2;
			buttonBack.Visible = false;
			buttonNext.Text = "Restart";
		}

		private void buttonBatchDetails_Click(object sender, EventArgs e)
		{
			dataToSend = @"ChargeanywhereProcessTransaction://?action=2&";
			dataToSend += "version=1.0";
			SendReceive(dataToSend, false);
			panelResults.BringToFront();
			currentPanelIndex = 2;
			buttonBack.Visible = false;
			buttonNext.Text = "Restart";
		}

		private void buttonCloseBatch_Click(object sender, EventArgs e)
		{
			dataToSend = @"ChargeanywhereProcessTransaction://?action=3&";
			dataToSend += "version=1.0";
			SendReceive(dataToSend, false);
			panelResults.BringToFront();
			currentPanelIndex = 2;
			buttonBack.Visible = false;
			buttonNext.Text = "Restart";
		}
	}


}
